/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.impl.registry;

import dev.engine_room.flywheel.api.registry.IdRegistry;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMaps;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import it.unimi.dsi.fastutil.objects.ReferenceCollections;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class IdRegistryImpl<T>
implements IdRegistry<T> {
    private static final ObjectList<IdRegistryImpl<?>> ALL = new ObjectArrayList();
    private final Object2ReferenceMap<class_2960, T> map = Object2ReferenceMaps.synchronize((Object2ReferenceMap)new Object2ReferenceOpenHashMap());
    private final Reference2ObjectMap<T, class_2960> reverseMap = Reference2ObjectMaps.synchronize((Reference2ObjectMap)new Reference2ObjectOpenHashMap());
    private final ObjectSet<class_2960> keysView = ObjectSets.unmodifiable((ObjectSet)this.map.keySet());
    private final ReferenceCollection<T> valuesView = ReferenceCollections.unmodifiable((ReferenceCollection)this.map.values());
    private boolean frozen;

    public IdRegistryImpl() {
        ALL.add((Object)this);
    }

    @Override
    public void register(class_2960 id, T object) {
        if (this.frozen) {
            throw new IllegalStateException("Cannot register to frozen registry!");
        }
        Object oldValue = this.map.put((Object)id, object);
        if (oldValue != null) {
            throw new IllegalArgumentException("Cannot override registration for ID '" + id + "'!");
        }
        class_2960 oldId = (class_2960)this.reverseMap.put(object, (Object)id);
        if (oldId != null) {
            throw new IllegalArgumentException("Cannot override ID '" + id + "' with registration for ID '" + oldId + "'!");
        }
    }

    @Override
    public <S extends T> S registerAndGet(class_2960 id, S object) {
        this.register(id, object);
        return object;
    }

    @Override
    @Nullable
    public T get(class_2960 id) {
        return (T)this.map.get((Object)id);
    }

    @Override
    @Nullable
    public class_2960 getId(T object) {
        return (class_2960)this.reverseMap.get(object);
    }

    @Override
    public T getOrThrow(class_2960 id) {
        T object = this.get(id);
        if (object == null) {
            throw new IllegalArgumentException("Could not find object for ID '" + id + "'!");
        }
        return object;
    }

    @Override
    public class_2960 getIdOrThrow(T object) {
        class_2960 id = this.getId(object);
        if (id == null) {
            throw new IllegalArgumentException("Could not find ID for object!");
        }
        return id;
    }

    @Override
    public @UnmodifiableView Set<class_2960> getAllIds() {
        return this.keysView;
    }

    @Override
    public @UnmodifiableView Collection<T> getAll() {
        return this.valuesView;
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public Iterator<T> iterator() {
        return this.getAll().iterator();
    }

    private void freeze() {
        this.frozen = true;
    }

    public static void freezeAll() {
        for (IdRegistryImpl registry : ALL) {
            registry.freeze();
        }
    }
}

